library(ggplot2)
library(ggbeeswarm)
library(ggpubr)
setwd("D:\\\\\\LIHC\\\\3.gene\\immune")
data1 <- read.csv("Regulatory.T.cell.csv")   ##
ggplot(data1,mapping=aes(Gene,expression,color=ZDHHC20))+   ##
  geom_quasirandom(dodge.width=.8,size = .8,method='smiley')+
  scale_y_continuous(limits = c(0.35, 1))+   #ķΧ
  theme_bw()+
  stat_summary(fun = median, size=1.5,geom = "errorbar", aes(ymax = ..y.., ymin = ..y..)
               ,width = 1,position = position_dodge(.8),show.legend = F)+
  stat_summary(aes(color = ZDHHC20),fun.data="mean_sdl", geom = "errorbar",fun.args = list(mult=1),   ##
               size = 1,width = .5,position = position_dodge(.8),show.legend = F)+
  stat_compare_means(label = "p.signif",show.legend = F,method="wilcox.test",symnum.args=list(cutpoints = c(0, 0.001, 0.01, 0.05, 1), symbols = c("***", "**", "*", " "))) +theme(axis.text.x=element_text(angle=45,hjust = 1,vjust=1))+
  labs(x="ZDHHC20",y="Regulatory.T.cell")+   ##
  theme(title = element_text(size = 20,colour = 'black'),
        plot.title = element_text(hjust = 0.5),
        panel.border = element_rect(fill=NA,color="black", size=2, linetype="solid"),
        axis.ticks.y = element_line(color='black', size=2, lineend = 10),
        legend.title = element_text(size = 13), 
        legend.text = element_text(size = 13),
        legend.key.size=unit(.5,'cm'),
        legend.position = "top",
        legend.box = "",
        axis.text.y = element_text(size = 11,colour = 'black'),
        axis.text.x = element_text(size = 11,colour = 'black'),
        axis.title.x = element_text(size = 15,colour = 'black'),
        axis.title.y = element_text(size = 15,colour = 'black'),
        strip.text.x = element_text(size = 15,colour = 'black'))+
  scale_color_manual('ZDHHC20',values=c('#00BFC4','#F8766D'),         ##
                     labels = c("Low", "mHigh"))+
  scale_shape_manual('ZDHHC20',values=c(21,21),                 ##
                     labels = c("Low", "mHigh"))+
  scale_fill_manual('ZDHHC20',values=c('#00BFC4','#F8766D'),          ##
                    labels = c("Low", "mHigh"))
ggsave("ZDHHC20-Regulatory.T.cell.pdf",device = "pdf",width = 4.5,height =6)       ##
 





